from datetime import datetime
from typing import Optional, Dict, List

from pydantic import BaseModel


class TableInsertSchema(BaseModel):
    module_name: str
    client: str
    ilens_version: int
    release_version: int
    feature_version: int
    patch_version: int
    image_tag: str
    last_updated_at: datetime

    class Config:
        orm_mode = True


class InsertRequest(BaseModel):
    module_name: str
    client: Optional[str] = 'iLens'
    insert_type: Optional[str] = "release"
    ilens_version: Optional[int] = 6
    release_version: Optional[int] = 0
    prefix_image: Optional[str] = "azrilensprod.azurecr.io/ilens/release/versions/"


class GetRequest(BaseModel):
    module_name: str
    client: Optional[str] = 'iLens'
    ilens_version: Optional[int]
    release_version: Optional[int]


class DockerComposeSchema(BaseModel):
    image: Optional[str] = ''
    container_name: Optional[str] = ''
    environment: Optional[Dict] = {}
    volumes: Optional[List] = []
    env_file: Optional[List] = ['variables.env']
    ports: Optional[List] = []
    command: Optional[List] = []
