from sqlalchemy import Column, Integer, String, Index, TIMESTAMP

from scripts.db.psql.databases import Base


class ILensVersionTable(Base):
    __tablename__ = "ilens_version_release"

    id = Column(Integer, autoincrement=True, primary_key=True)
    module_name = Column(String, index=True, nullable=False)
    client = Column(String, index=True, nullable=False)
    ilens_version = Column(Integer, nullable=False)
    release_version = Column(Integer, nullable=False)
    feature_version = Column(Integer, nullable=False)
    patch_version = Column(Integer, nullable=False)
    image_url = Column(String, nullable=False)
    updated_at = Column(TIMESTAMP(timezone=True), nullable=False, index=True)
    __table_args__ = (Index('version_index', "module_name", "client"),)
