import json
from copy import deepcopy

from scripts.config import EnvironmentVariables

if __name__ == "__main__":
    from dotenv import load_dotenv

    load_dotenv()
from scripts.db.psql.databases import get_db_for_func
from scripts.schemas import GetRequest

import logging
import os
import sys
import time

from scripts.core import ILensVersionHandler
from scripts.core.git_handler import GitHandler
from scripts.core.helm_handler import HelmHandler
from scripts.utils.common_utils import CommonUtils

default_link = EnvironmentVariables.default_link
helm_repo = EnvironmentVariables.helm_repo
global_configmap = EnvironmentVariables.global_configmap

HELM_PATH = "/ilens-core/ilens-modules"
HELM_STORE_PATH = "./helm-charts"


class HelmRegistration:
    def __init__(self, arguments: dict, git_user_name: str, git_access_token: str):
        self.arguments = arguments
        self.db_handler = ILensVersionHandler()
        self.helm_handler = HelmHandler()
        self.git_handler_obj = GitHandler(user_name=git_user_name, access_token=git_access_token)
        self.common_util = CommonUtils()

    def module_registration(self):
        helm_temp_path = f"{int(time.time())}_helm_tmp_path"
        general_temp_path = f"{int(time.time())}_tmp"
        output_path = f"{int(time.time())}_helm-charts"
        try:
            _ilens_version = self.arguments["ilens_version"]
            _release_version = self.arguments["release_version"]
            _client_name = self.arguments['client_name']
            _reference_branch = self.arguments['reference_client_name']
            _git_repos = self.arguments["git_repos"]
            _module_names = self.arguments["module_names"]
            _branch_name = self.arguments['branch_name'] or "master"
            repo_info = self.arguments["repo_info"]
            if repo_info:
                repo_info = json.loads(repo_info)
            if not _ilens_version or not _release_version or not _client_name or not _git_repos and not _module_names or not global_configmap:
                print(
                    "global_configmap, git_repos, module_names, client_name, ilens_version and release_version details not found!!!!!")
                sys.exit()
            _branch = f"{_client_name}_{_ilens_version}.{_release_version}"
            if not os.path.exists(helm_temp_path):
                os.makedirs(helm_temp_path)
            if not os.path.exists(output_path):
                os.makedirs(output_path)
            helm_path = os.path.join(helm_temp_path, "helm-charts")
            if not self.git_handler_obj.clone_repository(repo_link=helm_repo, module_output_path=helm_path,
                                                         clone_branch=_reference_branch or _client_name):
                logging.error(f"Cannot clone helm repo with branch: {_reference_branch or _client_name}")
            base_helm_directory_path = os.path.join(helm_temp_path, "helm-charts", "ilens-core", "ilens-modules")
            if os.path.exists(base_helm_directory_path) and len(_module_names) == 1 and _module_names[
                0].lower() == "all":
                updated_list = []
                files_info = os.listdir(base_helm_directory_path)
                sorted_files = list(filter(lambda f: f.endswith(".yml"), files_info))
                _module_names = [_each.replace(".yml", "") for _each in sorted_files]

            global_config_data = self.common_util.convert_yaml_to_define_obj(
                os.path.join(base_helm_directory_path, global_configmap))
            # global_config_data = common_util.convert_yaml_to_json("ilens-global-configmap.yml")
            if repo_info:
                global_config_data.update(repo_info)
            variables_file = "variables.yml"
            template_path = os.path.join(general_temp_path, "../templates")
            if not os.path.exists(template_path):
                os.makedirs(template_path)
            for _module in _module_names:
                module_path = os.path.join(general_temp_path)
                module_path = os.path.join(module_path, _module)
                if not os.path.exists(module_path):
                    os.makedirs(module_path)
                helm_out_file_path = os.path.join(output_path, f'{_module}.yml')
                if os.path.exists(helm_out_file_path):
                    logging.debug(f"Helm Deployment File found for selected the module {_module}")
                    continue
                variables_file_path = os.path.join(module_path, variables_file)
                git_info = self.git_handler_obj.get_git_url_by_module_name(module_name=_module)
                if not git_info:
                    logging.debug("Failed to fetch module info!! Skipping Helm File Preparation")
                    continue
                if not self.git_handler_obj.clone_repository_with_defined_file(repo_link=git_info,
                                                                               clone_branch=_branch_name,
                                                                               file_output_path=variables_file_path,
                                                                               clone_file_path=variables_file):
                    logging.debug("Failed to clone module!! Skipping Helm File Preparation")
                    continue
                _module_data = self.common_util.convert_yaml_to_define_obj(variables_file_path)
                module_env_variables = _module_data.get('deployment', {}).get('environmentVar', [])

                module_env_variables = {_v['name']: _v['value'] for _v in module_env_variables if
                                        {'name', 'value'}.issubset(set(list(_v.keys())))}
                template_file = os.path.join(template_path, f'{_module}.yml')
                session_obj = get_db_for_func()
                module_info = self.db_handler.get_module_versions(
                    input_data=GetRequest(module_name=_module, client='iLens', ilens_version=_ilens_version,
                                          release_version=_release_version), db=session_obj)
                session_obj.close()
                image_url = module_info.get("image_url", '') if module_info else ''
                existing_yml_path = os.path.join(base_helm_directory_path, f'{_module}.yml')
                new_module = deepcopy(_module)
                worker_type = "worker" in _module or "celery" in _module
                if not os.path.exists(existing_yml_path):
                    existing_yml_path = os.path.join("../templates", "helm_deployment.yml")
                    new_module = "helm_deployment"
                    self.helm_handler.create_helm_deployment_file(template_yml_path=existing_yml_path,
                                                                  image_tag=image_url,
                                                                  module_env_variables=module_env_variables,
                                                                  helm_out_file_path=helm_out_file_path,
                                                                  global_config_data=global_config_data,
                                                                  module_name=new_module)
                else:
                    self.helm_handler.create_existing_helm_deployment_file(template_yml_path=existing_yml_path,
                                                                           image_tag=image_url,
                                                                           module_env_variables=module_env_variables,
                                                                           helm_out_file_path=helm_out_file_path,
                                                                           global_config_data=global_config_data,
                                                                           module_name=new_module,
                                                                           template_file=template_file,
                                                                           template_path=template_path)
                if os.path.exists(base_helm_directory_path):
                    files_info = os.listdir(base_helm_directory_path)
                    sorted_files = list(filter(lambda f: f.startswith(_module), files_info))
                    updated_files_info = [x for x in sorted_files if f'{_module}.yml' != x]
                    for _file in updated_files_info:
                        sub_file_path = os.path.join(base_helm_directory_path, _file)
                        helm_out_file_path = os.path.join(output_path, _file)
                        template_file = os.path.join(template_path, _file)
                        worker_type = "worker" in _module or "celery" in _module
                        self.helm_handler.create_existing_helm_deployment_file(template_yml_path=sub_file_path,
                                                                               image_tag=image_url,
                                                                               module_env_variables=module_env_variables,
                                                                               template_file=template_file,
                                                                               template_path=template_path,
                                                                               helm_out_file_path=helm_out_file_path,
                                                                               global_config_data=global_config_data,
                                                                               service_type=False,
                                                                               module_name=_file.split(".yml")[0])
                # self.git_handler_obj.push_deployments_to_git(repo_link=helm_repo,
                #                                              private_token=git_access_token,
                #                                              branch=_client_name,
                #                                              folder_path=output_path, base_path=helm_path)

        except Exception as e:
            logging.exception(f"Exception Occurred while processing the Helm-Script Preparation {e.args}")
        finally:
            # shutil.rmtree(HELM_STORE_PATH)
            # shutil.rmtree(HELM_TEMP_PATH)
            # shutil.rmtree(GENERAL_TEMP_PATH)
            # shutil.rmtree(OUTPUT_PATH)
            ...
