if __name__ == "__main__":
    from dotenv import load_dotenv

    load_dotenv()
import argparse
import os
import sys
import time

from scripts.core import ILensVersionHandler
from scripts.core.docker_handler import DockerHandler
from scripts.core.git_handler import GitHandler
from scripts.logging import logging
from scripts.utils.common_utils import CommonUtils

common_util = CommonUtils()
variables_file_path = "docker-compose.yml"
_module_data = common_util.convert_yaml_to_define_obj(variables_file_path)
default_link = "https://gitlab-pm.knowledgelens.com/"
git_user_name = os.environ.get("GIT_USERNAME", default="harshavardhan.c")
git_access_token = os.environ.get("GIT_TOKEN", default="FEMA6PnP63fJCs6DrtZJ")
config_variables = os.environ.get("CONFIG_MAP_VARIABLES", default="").split(",")
docker_repo = os.environ.get("DOCKER_REPO",
                             default="https://gitlab-pm.knowledgelens.com/KnowledgeLens/Products/iLens-2.0/core/devops/docker-compose.git")
global_configmap = os.environ.get("GLOBAL_VARIABLES_FILE", default="ilens-env-spec-variables.yml")

git_handler_obj = GitHandler(user_name=git_user_name, access_token=git_access_token)
# for module in _module_data:


print(_module_data)
ap = argparse.ArgumentParser()
db_handler = ILensVersionHandler()
docker_handler = DockerHandler(git_user_name=git_user_name, git_access_token=git_access_token)
if __name__ == '__main__':
    ap.add_argument(
        "--ilens_version",
        "-iv",
        required=False,
        default=None,
        help="ILens Version Tag",
    )
    ap.add_argument(
        "--release_version",
        "-rv",
        required=False,
        default=None,
        help="ILens Release Tag",
    )
    ap.add_argument(
        "--client_name",
        "-cn",
        required=False,
        default=None,
        help="Client Name Tag"
    )
    ap.add_argument(
        "--branch_name",
        "-b",
        required=False,
        default=None,
        help="Branch Name"
    )
    ap.add_argument(
        "--git_repos",
        "-gr",
        required=False,
        default=None,
        help="Git repos to be added in helm",
        nargs="+"
    )
    ap.add_argument(
        "--module_names",
        "-mn",
        required=False,
        default=None,
        help="Module names to be added in helm",
        nargs="+"
    )
    DOCKER_TEMP_PATH = f"{int(time.time())}_docker_tmp_path"
    GENERAL_TEMP_PATH = f"{int(time.time())}_tmp"
    OUTPUT_PATH = f"{int(time.time())}_docker-compose"
    try:
        arguments = vars(ap.parse_args())
        _release_version = arguments["release_version"]
        _client_name = arguments['client_name']
        _git_repos = arguments["git_repos"]
        _module_names = arguments["module_names"]
        _branch_name = arguments['branch_name'] or "master"
        _ilens_version = arguments["ilens_version"]
        if not _ilens_version or not _release_version or not _client_name or not (
                _git_repos or _module_names) or not global_configmap:
            print(
                "global_configmap, git_repos, module_names, client_name, ilens_version and release_version details not found!!!!!")
            sys.exit()
        _branch = f"{_client_name}_{_ilens_version}.{_release_version}"
        variables_file = "variables.yml"
        if not os.path.exists(DOCKER_TEMP_PATH):
            os.makedirs(DOCKER_TEMP_PATH)
        if not os.path.exists(OUTPUT_PATH):
            os.makedirs(OUTPUT_PATH)
        docker_compose_path = os.path.join(DOCKER_TEMP_PATH, "docker-compose")
        if not git_handler_obj.clone_repository(repo_link=docker_repo, module_output_path=docker_compose_path,
                                                clone_branch=_client_name):
            logging.error(f"Cannot clone helm repo with branch: {_client_name}")
            sys.exit()
        files_info = os.listdir(docker_compose_path)
        sorted_files = list(filter(lambda f: f.endswith(".yml") and "docker" in f, files_info))
        global_config_data = common_util.convert_yaml_to_define_obj(os.path.join(docker_compose_path, global_configmap))

        for _file in sorted_files:
            docker_compose_data = common_util.convert_yaml_to_define_obj(os.path.join(docker_compose_path, _file),
                                                                         load_type=None)
            service_dict = docker_compose_data.get("services")
            if not service_dict:
                logging.debug(f'Services not found for current docker compose file  - {_file}')
            if response_data := docker_handler.process_module_request(compose_data=docker_compose_data,
                                                                      variables_file=variables_file,
                                                                      general_path=GENERAL_TEMP_PATH, **arguments):
                compose_out_file_path = os.path.join(OUTPUT_PATH, _file)
                common_util.convert_json_to_yaml(json_data=response_data, output_file_path=compose_out_file_path)
        git_handler_obj.push_deployments_to_git(repo_link=docker_repo, private_token=git_access_token, branch=_branch,
                                                folder_path=OUTPUT_PATH,helm_deployment=False,
                                                base_path=docker_compose_path)
        git_handler_obj.create_merge_request(repo_link=docker_repo, source_branch=_branch,
                                             destination_branch=_client_name)
    except Exception as e:
        logging.error(f'Exception occurred while preparing the docker compose {e.args}')
