import sys

from sqlalchemy import create_engine
from sqlalchemy_utils import database_exists, create_database

from scripts.config import DBConf
from scripts.db.psql.models import ILensVersionTable
from scripts.logging import logger

engine = create_engine(DBConf.DB_URI)


def create_default_psql_dependencies():
    try:
        if not database_exists(engine.url):
            create_database(engine.url)
        ILensVersionTable.__table__.create(bind=engine, checkfirst=True)

    except Exception as e:
        logger.error(f"Error occurred while creating: {e}", exc_info=True)
        sys.exit()
