import os

import ruamel.yaml

from scripts.logging import logging


class CommonUtils:

    @staticmethod
    def convert_yaml_to_json(yaml_file_path):
        try:
            if not os.path.exists(yaml_file_path):
                return {}
            _yaml = ruamel.yaml.YAML(typ='safe')
            _yaml.preserve_quotes = True
            with open(yaml_file_path) as fpi:
                yaml_dict = _yaml.load(fpi)
            return yaml_dict
        except Exception as e:
            logging.exception(f"Exception Occurred while reading the yaml file {e.args}")
            return {}

    @staticmethod
    def convert_json_to_yaml(json_data: dict, output_file_path):
        try:
            yaml = ruamel.yaml.YAML()
            yaml.preserve_quotes = True
            with open(output_file_path, 'w') as yaml_file:
                yaml.dump(json_data, yaml_file)
        except Exception as e:
            logging.exception(f"Exception Occurred while reading the yaml file {e.args}")
            return False
