from dataclasses import dataclass, field

from fastapi import FastAPI
from fastapi.middleware.cors import CORSMiddleware

import __version__
from scripts.db.psql.create_default_tables import create_default_psql_dependencies
from scripts.services import router


@dataclass
class FastAPIConfig:
    title: str = "ILens Version Management"
    description: str = "iLens Module Management and version Upgrades"
    version: str = __version__.version
    redoc_url: str = field(default=None)


app = FastAPI(**FastAPIConfig().__dict__)
app.include_router(router)
app.add_middleware(
    CORSMiddleware,
    allow_origins=["*"],
    allow_credentials=True,
    allow_methods=["GET", "POST", "DELETE", "PUT"],
    allow_headers=["*"],
)


@app.on_event("startup")
async def startup_event():
    """
    This function is to create default database and tables,
    """
    create_default_psql_dependencies()
