import os

import jinja2

from scripts.logging import logging
from scripts.utils.common_utils import CommonUtils


class HelmHandler:
    def __init__(self):
        self.common_utils = CommonUtils()
        ...

    def create_helm_deployment_file(self, template_yml_path, module_env_variables: dict, global_config_data: dict,
                                    image_tag: str, module_name: str, template_file: str, helm_out_file_path: str,
                                    template_path: str):
        try:
            if not os.path.exists(template_yml_path):
                logging.debug(f"{template_yml_path} not found!! Skipping Helm File Preparation")
                return False
            existing_data = self.common_utils.convert_yaml_to_json(template_yml_path)
            global_config_vars = global_config_data.get('data', {})
            existing_env_variables = {_v['name']: _v for _v in
                                      existing_data.get('deployment', {}).get('environmentVar', [])}
            diff_keys = list(set(existing_env_variables.keys()).symmetric_difference(set(module_env_variables.keys())))
            for _each in diff_keys:
                if _each.lower() in {'port', 'service_port', 'module_port'} and module_env_variables[_each].get(
                        "value"):
                    global_config_vars["SERVICE_PORT"] = module_env_variables[_each]["value"]
                    continue
                if module_env_variables.get(_each):
                    existing_data['deployment']['environmentVar'].append(module_env_variables[_each])
            existing_data['deployment']['imageName'] = image_tag or existing_data['deployment']['imageName']

            self.common_utils.convert_json_to_yaml(json_data=existing_data, output_file_path=template_file)
            self.render_helm_chart(data_dict=global_config_vars, helm_template_file=f'{module_name}.yml',
                                   outfile_path=helm_out_file_path, template_path=template_path)
            return True
        except Exception as e:
            logging.exception(f'Exception occurred while preparing the helm deployment file {e.args}')
            return False

    @staticmethod
    def render_helm_chart(data_dict, helm_template_file, template_path, outfile_path):
        try:
            environment = jinja2.Environment(
                loader=jinja2.FileSystemLoader(searchpath=template_path),
                trim_blocks=True,
                variable_start_string='<{', variable_end_string='}>', autoescape=True)
            _render = environment.get_template(helm_template_file).render(**data_dict)
            with open(outfile_path, "w") as fp:
                fp.write(_render)

        except Exception as e:
            logging.exception(f"Exception occurred while rendering the helm file  - {e.args}")
