from scripts.utils.common_utils import CommonUtils

if __name__ == "__main__":
    from dotenv import load_dotenv

    load_dotenv()
import os
import sys
import time

from scripts.config import EnvironmentVariables
from scripts.core import ILensVersionHandler
from scripts.core.docker_handler import DockerHandler
from scripts.core.git_handler import GitHandler
from scripts.logging import logging

docker_repo = EnvironmentVariables.docker_repo
global_configmap = EnvironmentVariables.global_configmap


class DockerVersionUpgrade:
    def __init__(self, arguments: dict, git_user_name: str, git_access_token: str):
        self.arguments = arguments
        self.db_handler = ILensVersionHandler()
        self.docker_handler = DockerHandler(git_user_name=git_user_name, git_access_token=git_access_token)
        self.git_handler_obj = GitHandler(user_name=git_user_name, access_token=git_access_token)
        self.common_util = CommonUtils()

    def module_registration(self):
        docker_temp_path = f"{int(time.time())}_docker_tmp_path"
        general_temp_path = f"{int(time.time())}_tmp"
        output_path = f"{int(time.time())}_docker-compose"
        try:
            self.process_docker_automation(docker_temp_path, output_path, general_temp_path)

        except Exception as e:
            logging.error(f'Exception occurred while preparing the docker compose {e.args}')

    def process_docker_automation(self, docker_temp_path, output_path, general_temp_path):
        _ilens_version = self.arguments["ilens_version"]
        _release_version = self.arguments["release_version"]
        _client_name = self.arguments['client_name']
        _git_repos = self.arguments["git_repos"].split(',')
        _module_names = self.arguments["module_names"].split(',')
        extra_modules = self.arguments["extra_modules"].split(',')
        _branch_name = self.arguments['branch_name'] or "master"
        _reference_branch = self.arguments['reference_client_name']
        if not _ilens_version or not _release_version or not _client_name or not global_configmap:
            print(
                "global_configmap, client_name, ilens_version and release_version details "
                "not found!!!!!")
            sys.exit()
        variables_file = "variables.yml"
        if not os.path.exists(docker_temp_path):
            os.makedirs(docker_temp_path)
        if not os.path.exists(output_path):
            os.makedirs(output_path)
        docker_compose_path = os.path.join(docker_temp_path, "docker-compose")
        _branch = f"{_client_name}_{_ilens_version}.{_release_version}"
        if not self.git_handler_obj.clone_repository(repo_link=docker_repo, module_output_path=docker_compose_path,
                                                     clone_branch=_client_name):
            logging.error(f"Cannot clone docker repo with branch: {_client_name}")
            sys.exit()
        self.docker_handler.process_compose_data_for_existing_files(destination_branch=_client_name,
                                                                    source_branch=_branch,
                                                                    variables_file=variables_file,
                                                                    arguments=self.arguments,
                                                                    tmp_path=general_temp_path,
                                                                    output_path=output_path,
                                                                    docker_compose_path=docker_compose_path)
        self.git_handler_obj.push_deployments_to_git(repo_link=docker_repo,
                                                     private_token=EnvironmentVariables.git_access_token,
                                                     branch=_branch,
                                                     folder_path=output_path, helm_deployment=False,
                                                     base_path=docker_compose_path)
        self.git_handler_obj.create_merge_request(repo_link=docker_repo, source_branch=_branch,
                                                  destination_branch=_client_name)
