from copy import deepcopy

import pendulum
from sqlalchemy.orm import Session

from scripts.db.psql.ilens_version_table import ILensVersionMaster
from scripts.logging import logger
from scripts.schemas import InsertRequest, GetRequest, TableInsertSchema


class ILensVersionHandler:
    def __init__(self):
        ...

    @staticmethod
    def update_module_versions(input_data: InsertRequest, db: Session):
        ilens_version_db = ILensVersionMaster(db=db)
        try:
            curr_time = pendulum.now()
            if input_data.prefix_image.endswith("/"):
                input_data.prefix_image = input_data.prefix_image[:-1]
            db_json = dict(module_name=input_data.module_name, client=input_data.client,
                           ilens_version=input_data.ilens_version,
                           release_version=input_data.release_version,
                           feature_version=0, patch_version=0)
            if (existing_data := ilens_version_db.read_data_from_db(input_data=GetRequest(**input_data.dict()),
                                                                    db=db)):

                if input_data.insert_type == "ilens_version":
                    existing_data["ilens_version"] += 1
                    existing_data.update(feature_version=0, patch_version=0)
                elif input_data.insert_type == "release":
                    existing_data["release_version"] += 1
                    existing_data.update(feature_version=0, patch_version=0)
                elif input_data.insert_type == "feature":
                    existing_data["feature_version"] += 1
                else:
                    existing_data["patch_version"] += 1
            if not existing_data:
                existing_data = deepcopy(db_json)
            concat_string = f'v{existing_data["ilens_version"]}.{existing_data["release_version"]}'
            existing_data["image_tag"] = f'{input_data.prefix_image}/' \
                                         f'{concat_string}:{existing_data["module_name"]}-{concat_string}.{existing_data["feature_version"]}.{existing_data["patch_version"]}'
            existing_data.pop("last_updated_at", None)

            return ilens_version_db.add_module_version_record(
                insert_record=TableInsertSchema(**existing_data, last_updated_at=curr_time))

        except Exception as e:
            logger.exception(f'Exception Occurred while updating the record in db {e.args}')
            raise

    @staticmethod
    def get_module_versions(input_data: GetRequest, db: Session):
        ilens_version_db = ILensVersionMaster(db=db)
        try:

            if existing_data := ilens_version_db.read_data_from_db(input_data=GetRequest(**input_data.dict()),
                                                                   db=db):
                return existing_data
        except Exception as e:
            logger.exception(f'Exception Occurred while getting the record in db {e.args}')
            raise
        return {}
