import argparse
import json
import sys

from dotenv import load_dotenv

load_dotenv()
from helm_automation.helm_register import HelmRegistration

from docker_automation.docker_automate_script import DockerVersionUpgrade
from helm_automation.helm_automate_script import HelmVersionUpgrade
from docker_automation.docker_register import DockerRegistration
from scripts.config import EnvironmentVariables
from scripts.logging import logger

default_link = EnvironmentVariables.default_link
git_user_name = EnvironmentVariables.git_user_name
git_access_token = EnvironmentVariables.git_access_token
config_variables = EnvironmentVariables.config_variables
helm_repo = EnvironmentVariables.helm_repo
global_configmap = EnvironmentVariables.global_configmap
ap = argparse.ArgumentParser()


def func_mapper(operation_type, parameters):
    func_mapper_dict = {
        "docker_registration": DockerRegistration(arguments=parameters, git_user_name=git_user_name,
                                                  git_access_token=git_access_token).module_registration,
        "docker_version_upgrade": DockerVersionUpgrade(arguments=parameters, git_user_name=git_user_name,
                                                       git_access_token=git_access_token).module_registration,
        "helm_version_upgrade": HelmVersionUpgrade(arguments=parameters, git_user_name=git_user_name,
                                                   git_access_token=git_access_token).module_registration,
        "helm_registration": HelmRegistration(arguments=parameters, git_user_name=git_user_name,
                                              git_access_token=git_access_token).module_registration
    }
    return func_mapper_dict.get(operation_type)


if __name__ == '__main__':
    ap.add_argument(
        "--ilens_version",
        "-iv",
        required=False,
        default=None,
        help="ILens Version Tag",
    )
    ap.add_argument(
        "--release_version",
        "-rv",
        required=False,
        default=None,
        help="ILens Release Tag",
    )
    ap.add_argument(
        "--reference_client_name",
        "-rcn",
        required=False,
        default=None,
        help="Client Name Tag"
    )
    ap.add_argument(
        "--client_name",
        "-cn",
        required=False,
        default=None,
        help="Client Name Tag"
    )
    ap.add_argument(
        "--branch_name",
        "-b",
        required=False,
        default=None,
        help="Branch Name"
    )
    ap.add_argument(
        "--git_repos",
        "-gr",
        required=False,
        default='',
        help="Git repos to be added in docker compose",
    )
    ap.add_argument(
        "--module_names",
        "-mn",
        required=False,
        default='',
        help="Module names to be added in docker compose",
    )
    ap.add_argument(
        "--repo_info",
        "-ri",
        required=False,
        default='',
        help="Module names to be added in docker compose",
    )
    ap.add_argument(
        "--execution_type",
        "-et",
        required=False,
        default=None,
        help="Type of Execution will be selected.."
    )
    ap.add_argument(
        "--extra_modules",
        "-em",
        required=False,
        default='data-processor',
        help="Extra Modules to be included in script",
    )
    try:
        arguments = vars(ap.parse_args())
        _ilens_version = arguments["ilens_version"]
        _release_version = arguments["release_version"]
        _client_name = arguments['client_name']
        _reference_branch = arguments['reference_client_name']
        _git_repos = arguments["git_repos"]
        _module_names = arguments["module_names"]
        extra_modules = arguments["extra_modules"]
        _branch_name = arguments['branch_name'] or "master"
        if repo_info := arguments["repo_info"]:
            repo_info = json.loads(repo_info)
        func_type = arguments['execution_type']
        temp_func = func_mapper(operation_type=func_type, parameters=arguments)
        if not temp_func:
            logger.exception('Execution Type is not Found')
            sys.exit()
        res = temp_func()
    except Exception as e:
        logger.exception(f'Exception Occurred while performing automation script preparation {e.args}')
