from fastapi import Depends, APIRouter
from sqlalchemy.orm import Session

from scripts.core import ILensVersionHandler
from scripts.db.psql.databases import get_db
from scripts.logging import logger
from scripts.schemas import InsertRequest, GetRequest

router = APIRouter()


@router.post("/module/increment_version")
def increment_version_release(input_data: InsertRequest, db: Session = Depends(get_db)):
    try:
        db_handler = ILensVersionHandler()
        return db_handler.update_module_versions(input_data, db)
    except Exception as e:
        logger.exception(f"Exception occurred while updating the tag version {e.args}")
        return {}


@router.get("/module/increment_version")
def get_increment_version_release(input_data: GetRequest = Depends(), db: Session = Depends(get_db)):
    try:
        db_handler = ILensVersionHandler()
        return db_handler.get_module_versions(input_data, db)
    except Exception as e:
        logger.exception(f"Exception occurred while updating the tag version {e.args}")
        return {}
