from copy import deepcopy

from scripts.constants.db_connections import mongo_client
from scripts.constants.ui_constants import DonutChart, BaseWaterChart
from scripts.db.mongo.ilens_configuration.collections.constants import Constants

from scripts.schemas.batch_oee import WaterFallChart


class ChartMaker:
    def __init__(self, project_id=None):
        self.constants_con = Constants(mongo_client=mongo_client)

    def main_creator(self, data, activity_length, overall=True):
        chart_data = dict()
        chart_data["waterfall"] = self.waterfall_chart(WaterFallChart(**data))
        return self.donut_chart(data, chart_data, activity_length, overall)

    @staticmethod
    def waterfall_chart(data: WaterFallChart):
        availability_to = 100 - data.availability_loss
        performance_to = availability_to - data.performance_loss
        quality_to = performance_to - data.quality_loss
        oee_to = 0
        first_series = [0, availability_to, performance_to, quality_to, oee_to]
        second_series = [
            100,
            data.availability_loss,
            data.performance_loss,
            data.quality_loss,
            data.oee,
        ]
        waterfall_base = BaseWaterChart.waterfall_base
        waterfall_base["data"]["series"][0]["data"] = BaseWaterChart.waterfall_series_builder(
            first_series
        )
        waterfall_base["data"]["series"][1]["data"] = BaseWaterChart.waterfall_series_builder(
            second_series
        )
        return waterfall_base["data"]

    @staticmethod
    def donut_chart(data, chart_data, activity_length, overall: bool):
        base = DonutChart.base
        chart_keys = DonutChart.chart_keys
        for each in chart_keys:
            color_map = DonutChart.color_mapping[each]["colors"]
            each_base = base.copy()
            actual_value = data[each]
            rounded_value = round(data[each] / 100, 2)
            each_base["series"]["axisLine"]["lineStyle"]["color"] = [
                [rounded_value, color_map[0]],
                [1, color_map[1]],
            ]
            each_base["series"]["detail"]["formatter"] = (
                each.capitalize().replace("_", " ")
                if each != "oee"
                else each.upper().replace("_", " ")
            )
            each_base["series"]["data"] = [
                dict(value=actual_value, name=f"{actual_value}%")
            ]
            chart_data[each] = deepcopy(each_base)
        do_not_display = DonutChart.chart_keys + DonutChart.waterfall_chart_keys
        for k, v in data.items():
            if k not in do_not_display:
                if k in ["total_units", "good_units"] and not overall:
                    v = round(v - activity_length, 2)
                chart_data.update(
                    {
                        k: dict(label=k.capitalize().replace("_", " "), value=v)
                    }
                )
        return chart_data
