import pytz

if __name__ == '__main__':
    from dotenv import load_dotenv

    load_dotenv()

import time
from datetime import datetime
from production_monitoring import ProductionMonitor

production_mon = ProductionMonitor()


def calculate_setup_time():
    data = production_mon.oee_mongo.find_record_by_status("started")
    if not data:
        print("No data found, waiting for batch to start")
        return
    tz = data.get("form_details", {}).get("tz", "Asia/Bangkok")
    prod_start_time = datetime.fromtimestamp(
        int(data.get("start_time") / 1000),
        tz=pytz.timezone(tz))
    setup_time = production_mon.calculate_setup_time(prod_start_time, tz)

    data["setup_time"] = setup_time
    data["run_start_time"] = int(time.time() * 1000)
    data["prod_status"] = "running"

    production_mon.oee_mongo.update_oee(data, data.get("job", ""), data.get("uf_process", ""), False)


if __name__ == '__main__':
    while True:
        calculate_setup_time()
        time.sleep(10)
