import pandas as pd
import json

file_path = "../../data/ilens_tags.csv"

op_file_path = "../../data/model_op_tags.csv"

def get_keys():
    df = pd.read_csv(file_path)

    selected_data = {
        "Site": ['Bharuch-Unit 2'],
        "Plant": ['CTCMP'],
        "Line": ['Stage IIA - Chlorination & Neutralization-I'],
        "Equipment": ['Reactor R-7204']
    }

    for each_level in selected_data:
        df = df.loc[df[each_level].isin(selected_data[each_level])]

    final_data = df.to_dict(orient="records")
    record_data = dict()

    for each_data in final_data:
        record_data[each_data["Tag ID"]] = each_data["Tag Name"]

    print("******************************************")
    print(json.dumps(record_data))
    print("******************************************")
    print("******************************************")
    print(json.dumps(list(record_data.keys())))
    print("******************************************")


def get_op_tags():
    df = pd.read_csv(op_file_path)

    final_data = df.to_dict(orient="records")
    record_data = dict()

    for each_data in final_data:
        for range_key in ['lower', 'upper', 'original']:
            key = f"{each_data['parameters']}_{range_key}"
            record_data[key] = each_data[f"{range_key}_parameter_SITE_id"]
    
    print("******************************************")
    print(json.dumps(record_data))
    print("******************************************")

if __name__ == '__main__':
    # get_keys()
    get_op_tags()