from fastapi.responses import JSONResponse
from fastapi import status

from scripts.logging.logger import logger
from scripts.schemas.default_responses import DefaultResponse
from scripts.utils.response_utils import ResponseData

obj_download_util = ResponseData()


class DashboardManagement:
    def __init__(self):
        self.download_files = obj_download_util.download_file_data()

    def download_header(self):
        try:
            data = {
                "actions": [
                    {
                        "class": "fa-download",
                        "action": "download",
                        "tooltip": "Download"
                    }
                ],
                "columnDefs": [
                    {
                        "headerName": "File Name",
                        "field": "file_name",
                        "key": "file_name"
                    }],

            }
            column_urls = [{"file_name": key, "file_url": value} for key, value in self.download_files.items()]
            data["rowData"] = column_urls
            return JSONResponse(
                content=DefaultResponse(status="success", message="Fetched Successfully",
                                        data=data).dict(),
                status_code=status.HTTP_200_OK)
        except Exception as e:
            logger.exception(e)
