import base64
from Cryptodome.Cipher import AES
from scripts.config import Secrets, Services
from scripts.logging.logger import logger


class DecryptPassword:

    @staticmethod
    def un_pad(s):
        # un_padding the encrypted password
        return s[:-ord(s[len(s) - 1:])]

    def password_decrypt(self, password):
        try:
            # encoding the Key
            key = Secrets.KEY_ENCRYPTION.encode(Services.ENCODING_TYPE)
            # decoding the received password
            enc = base64.b64decode(password)
            # mode for the decryption
            mode = AES.MODE_CBC
            # getting the initialization vector
            iv = enc[:AES.block_size]
            # decoding with AES
            cipher = AES.new(key, mode, iv)
            # decoding the password
            data = cipher.decrypt(enc[AES.block_size:])
            if len(data) == 0:
                raise ValueError("Decrypted data is empty")
            # removing the padding to get the password
            data = self.un_pad(data)
            return data.decode(Services.ENCODING_TYPE)
        except Exception as e:
            logger.exception(e)
