from pydantic import BaseSettings, Field


class _Services(BaseSettings):
    HOST: str = Field(default="127.0.0.1", env="service_host")
    PORT: int = Field(default=8000, env="service_port")
    PROJECT_NAME = Field(default="AssetManager", env="project_name")
    ENCODING_TYPE = Field(default="utf-8", env="encoding_type")
    ENABLE_CORS: bool = True
    CORS_URLS: list[str] = ["*.ilens.io"]
    CORS_ALLOW_CREDENTIALS: bool = True
    CORS_ALLOW_METHODS: list[str] = ["GET", "POST", "DELETE", "PUT"]
    CORS_ALLOW_HEADERS: list[str] = ["*"]
    LOG_LEVEL: str
    BACKUP_COUNT: int
    MAX_BYTES: int
    ENABLE_FILE_LOGGING: bool = True
    EMAIL_SENDER: str
    EMAIL_SMTP: str
    EMAIL_PORT: int
    EMAIL_PASSWORD: str
    HTML_LINK: str
    RESET_ENDPOINT: str
    REDIRECT_URL_RESET: str
    DATE_TIME = '%Y-%m-%d %H:%M:%S'


class _Databases(BaseSettings):
    MONGO_URI: str
    DB_NAME: str
    REDIS_URI: str
    REDIS_LOGIN_DB: int


class _PathConf(BaseSettings):
    LOG_PATH: str


class _Secrets(BaseSettings):
    ACCESS_TOKEN_EXPIRE_MINUTES = 480
    TOKEN_EXPIRE_TIME = 5
    leeway_in_minutes: int = 10
    KEY_ENCRYPTION: str
    CLIENT_ID: str
    issuer: str = "iotManager"
    SECRET_KEY: str
    ALGORITHM = "HS256"


Services = _Services()
Databases = _Databases()
PathConf = _PathConf()
Secrets = _Secrets()

__all__ = [
    "Services",
    "Databases",
    "PathConf",
    "Secrets"
]
