import re

from scripts.logging.logger import logger


# for data validations
class RegexValidation:
    @staticmethod
    def name_validation(name):
        try:
            regex = re.fullmatch(r'^([A-Za-z]+)*$', str(name))
            return regex
        except Exception as e:
            logger.error(f'Error in name regex {str(e)}')
            return None

    @staticmethod
    def phone_number_validation(phone_number):
        try:
            regex = re.fullmatch('([0-9]{1,20})', str(phone_number))
            return regex
        except Exception as e:
            logger.error(f'An Error in phone number regex {str(e)}')
            return None

    @staticmethod
    def password_validation(password):
        try:
            password_regex = r'^(?=.*[a-z])(?=.*[A-Z])(?=.*[!@#$%^&*()_+={}[\]:;\"\'|,.<>\/?]).{8,15}$'
            if re.search(password_regex, password):
                return False

        except Exception as e:
            logger.error(f'Error in password regex {str(e)}')
            return None
