import bcrypt

from scripts.database.mongo.mongo_login import MongoUser
from scripts.logging.logger import logger


class LoginManager:
    @staticmethod
    def verify_password(encrypted_password, password):
        pwd = password
        decoded_pwd = pwd.encode('utf-8')
        print(encrypted_password, password)
        if bcrypt.checkpw(encrypted_password, decoded_pwd):
            return True
        return False

    @staticmethod
    def hashed_password(password):
        try:
            pwd = password
            encode_pwd = pwd.encode('utf-8')
            # Generate salt
            salted = bcrypt.gensalt()

            # Hash password
            pwd_hash = bcrypt.hashpw(encode_pwd, salted)

            return pwd_hash
        except Exception as e:
            logger.exception(e)

    @staticmethod
    def get_data(username):
        data = MongoUser().fetch_user_details(username)
        return data
