import uuid
from datetime import datetime, timedelta, timezone

from scripts.config import Secrets
from scripts.database.mongo.mongo_db import MongoUser
from scripts.database.redis.redis_conn import login_db
from scripts.utils.security.jwt_util import JWT

jwt = JWT()
mongo_user = MongoUser()


def create_token(
        user_id,
        ip,
        login_token=None,
        age=Secrets.ACCESS_TOKEN_EXPIRE_MINUTES,
):
    """
    This method is to create a cookie
    """
    uid = login_token
    if not uid:
        uid = str(uuid.uuid4()).replace("-", "")
    # creating the payload
    payload = {"ip": ip, "user_id": user_id, "token": Secrets.SECRET_KEY, "uid": uid, "age": age}
    # getting the current time
    current_time = datetime.now(timezone.utc)
    # generating the expiry time of the token
    exp = current_time + timedelta(minutes=age)
    # creating the dictionary with issuer and expiry time
    _extras = {"iss": Secrets.issuer, "exp": exp}
    _payload = payload | _extras
    # encoding the token
    new_token = jwt.encode(_payload)
    # Add session to redis
    login_db.set(uid, new_token)
    login_db.expire(uid, timedelta(minutes=age))
    # Add updated time to mongo db
    mongo_user.update_user({"user_id": user_id}, {"updated_at": current_time})
    return uid, exp
