import uuid
from datetime import datetime, timedelta, timezone

from scripts.config import Secrets
from scripts.database.redis.redis_conn import login_db
from scripts.utils.security.jwt_util import JWT

jwt = JWT()


def create_token(
        user_id,
        ip,
        age=Secrets.ACCESS_TOKEN_EXPIRE_MINUTES,
        project_id=None,
):
    """
    This method is to create a cookie
    """

    payload = {"ip": ip, "user_id": user_id, "token": Secrets.SECRET_KEY, "age": age}
    if project_id:
        payload["project_id"] = project_id
    exp = datetime.now() + timedelta(minutes=age)
    _extras = {"iss": Secrets.issuer, "exp": exp}
    _payload = payload | _extras
    new_token = jwt.encode(_payload)

    # Add session to redis
    login_db.set(user_id, new_token)
    login_db.expire(user_id, timedelta(minutes=age))

    return user_id
