import pathlib
from typing import Literal

from pydantic import BaseSettings, Field


class _Services(BaseSettings):
    HOST: str = Field(default="127.0.0.1", env="service_host")
    PORT: int = Field(default=8000, env="service_port")
    PROJECT_NAME = Field(default="AssetManager", env="project_name")
    ENCODING_TYPE = Field(default="utf-8", env="encoding_type")
    ENABLE_CORS: bool = True
    CORS_URLS: list[str] = ["*.ilens.io"]
    CORS_ALLOW_CREDENTIALS: bool = True
    CORS_ALLOW_METHODS: list[str] = ["GET", "POST", "DELETE", "PUT"]
    CORS_ALLOW_HEADERS: list[str] = ["*"]
    LOG_LEVEL: Literal["INFO", "DEBUG", "ERROR", "QTRACE"] = "INFO"
    ENABLE_FILE_LOGGING: bool = False


class _Databases(BaseSettings):
    MONGO_URI: str
    DB_NAME: str
    REDIS_URI: str
    REDIS_LOGIN_DB: int


class _BasePathConf(BaseSettings):
    BASE_PATH: str = "scripts/"


class _PathConf:
    BASE_PATH: pathlib.Path = pathlib.Path(_BasePathConf().BASE_PATH)
    LOG_PATH: pathlib.Path = BASE_PATH / "log/"


class _Secrets(BaseSettings):
    ACCESS_TOKEN_EXPIRE_MINUTES = 30
    leeway_in_minutes: int = 10
    KEY_ENCRYPTION: str
    issuer: str = "iotManager"
    SECRET_KEY = "09d25e094faa6ca2556c818166b7a9563b93f7099f6f0f4caa6cf63b88e8d3e7"
    ALGORITHM = "HS256"


Services = _Services()
Databases = _Databases()
PathConf = _PathConf()
Secrets = _Secrets()

__all__ = [
    "Services",
    "Databases",
    "PathConf",
    "Secrets"
]
