from fastapi import Response

from scripts.core.handlers.normal_login import NormalLogin
from fastapi.responses import JSONResponse
from fastapi import status
from scripts.errors import ErrorMessages
from scripts.schemas.default_responses import DefaultFailureResponse, DefaultResponse
from scripts.utils.security.password_util import EncryptDecryptPassword


class LoginHandlers:
    def __init__(self):
        self.obj_login_handler = NormalLogin()
        self.pass_decrypt = EncryptDecryptPassword()
        self.login_type = ""

    def normal_login(self, user_data, request):
        self.login_type = "normal"
        # decrypting the password from the UI
        decrypted_password = self.pass_decrypt.password_decrypt(user_data.password)
        # validating the received inputs empty or not
        responses = self.obj_login_handler.user_data_validation(
            user_data.email,
            decrypted_password.split("\"")[1])
        # Account is not registered
        if responses is not None:
            return JSONResponse(content=DefaultFailureResponse(status="failed",
                                                               message=responses).dict(),
                                status_code=status.HTTP_200_OK)
        # checking for the account and password matching
        user_data_response, data = self.obj_login_handler.db_password_matching(self.login_type, user_data,
                                                                               decrypted_password.split("\"")[1])
        # if the passwords doesn't match with the db data
        if user_data_response is not None:
            return JSONResponse(content=DefaultFailureResponse(status="failed",
                                                               message=data).dict(),
                                status_code=status.HTTP_200_OK)

        #  generating the access tokens
        responses, exp = self.obj_login_handler.generate_cookie_tokens(user_data, request)
        # token generation unsuccessful
        if responses is None:
            return JSONResponse(
                content=DefaultFailureResponse(status="failed",
                                               message=ErrorMessages.ERROR_TOKEN_GENERATION).dict(),
                status_code=status.HTTP_200_OK)
        # sending successful response to UI
        response = JSONResponse(
            content=DefaultResponse(status="success", message="Logged In Successfully", data=data).dict(),
            status_code=status.HTTP_200_OK, headers={"Content-Type": "application/json"})
        response.set_cookie(key="login-token", value=responses, expires=exp)
        return response

    # v1
    def google_login(self, request):
        pass

    # v2
    def microsoft_login(self, request):
        pass
