import configparser
from typing import Optional, Literal

from pydantic import BaseSettings, Field

config = configparser.RawConfigParser()
config.read("conf/application.conf")
PROJECT_NAME = config.get("project_name", "PROJECT_NAME")


class _Services(BaseSettings):
    HOST: str = Field(default="127.0.0.1", env="service_host")
    PORT: int = Field(default=8000, env="service_port")
    ENABLE_CORS: bool = True
    CORS_URLS: list[str] = ["*.ilens.io"]
    CORS_ALLOW_CREDENTIALS: bool = True
    CORS_ALLOW_METHODS: list[str] = ["GET", "POST", "DELETE", "PUT"]
    CORS_ALLOW_HEADERS: list[str] = ["*"]
    SELF_PROXY: Optional[str] = Field(None, env="DIGITAL_SIGNATURE_PROXY")
    LOG_LEVEL: Literal["INFO", "DEBUG", "ERROR", "QTRACE"] = "INFO"
    ENABLE_FILE_LOGGING: bool = False
    SECRET_KEY = "a8f3e3ed5f0dd73bca711df807b1141e15a499bc5e555d44fcab501c4147ee23"
    ALGORITHM = "HS256"
    ACCESS_TOKEN_EXPIRES_MINUTES = 800


class _Databases(BaseSettings):
    MONGO_URI: str


Services = _Services()
Databases = _Databases()

__all__ = [
    "PROJECT_NAME",
    "Services",
    "Databases",
]
