from fastapi.security import OAuth2PasswordBearer
from passlib.context import CryptContext


class LoginManager:
    def __init__(self):
        self.pwd_context = CryptContext(schemes=["bcrypt"], deprecated="auto")
        self.oauth2_scheme = OAuth2PasswordBearer(tokenUrl="token")

    def hashed_password(self, password):
        return self.pwd_context.hash(password)

    # def get_data(self, username, hashed):
