import configparser
from typing import Optional, Literal

from pydantic import BaseSettings, Field

config = configparser.RawConfigParser()
config.read("conf/application.conf")
PROJECT_NAME = config.get("project_name", "PROJECT_NAME")


class _Services(BaseSettings):
    HOST: str = Field(default="127.0.0.1", env="service_host")
    PORT: int = Field(default=8000, env="service_port")
    ENABLE_CORS: bool = True
    CORS_URLS: list[str] = ["*.ilens.io"]
    CORS_ALLOW_CREDENTIALS: bool = True
    CORS_ALLOW_METHODS: list[str] = ["GET", "POST", "DELETE", "PUT"]
    CORS_ALLOW_HEADERS: list[str] = ["*"]
    LOG_LEVEL: Literal["INFO", "DEBUG", "ERROR", "QTRACE"] = "INFO"
    ENABLE_FILE_LOGGING: bool = False
    SECRET_KEY = "09d25e094faa6ca2556c818166b7a9563b93f7099f6f0f4caa6cf63b88e8d3e7"
    ALGORITHM = "HS256"
    ACCESS_TOKEN_EXPIRE_MINUTES = 30


class _Databases(BaseSettings):
    MONGO_URI: str
    DB_NAME: str


Services = _Services()
Databases = _Databases()

__all__ = [
    "PROJECT_NAME",
    "Services",
    "Databases",
]
