from fastapi import APIRouter

from scripts.constants.api import ApiEndPoints
from scripts.core.handlers.login_handler import LoginHandlers
from scripts.logging.logger import logger
from scripts.schemas.default_responses import DefaultResponse, DefaultFailureResponse
from scripts.schemas.login_schema import NormalLogin

router = APIRouter(prefix=ApiEndPoints.version)
obj_login_handler = LoginHandlers()


@router.post(ApiEndPoints.asset_manager_submit)
def login_default(login_data: NormalLogin):
    try:
        response = obj_login_handler.user_data_validation(login_data)
        if response is not None:
            return DefaultFailureResponse(error=response["message"])
        response = obj_login_handler.db_password_matching(login_data)
        if response is not None:
            return DefaultFailureResponse(error=response["message"])
        return DefaultResponse(message="Login Successful", payload={"username": login_data.username})
    except Exception as e:
        logger.exception(e)
