from typing import Optional

from pydantic import BaseModel


# model for login request
class LoginRequest(BaseModel):
    login_type: str
    email: str
    password: str


class RegistrationData(BaseModel):
    name: str
    email: str
    password: Optional[str]
    phone_number: Optional[str]
    login_type: str
    user_role: str


class UserActions(BaseModel):
    action: str
    user_id: Optional[str] = None
    name: Optional[str] = None
    email: Optional[str] = None
    password: Optional[str]
    phone_number: Optional[str] = None
    login_type: Optional[str] = None
    user_role: Optional[str] = None


class UsersFilter(BaseModel):
    name: Optional[str] = None
    email: Optional[str] = None
    user_role: Optional[str] = None


class UserIDValidation(BaseModel):
    user_id: str


class EmailValidation(BaseModel):
    email: str
