import configparser
from typing import Literal

from pydantic import BaseSettings, Field

config = configparser.RawConfigParser()
config.read("conf/application.conf")


class _Services(BaseSettings):
    HOST: str = Field(default="127.0.0.1", env="service_host")
    PORT: int = Field(default=8000, env="service_port")
    PROJECT_NAME = config.get("PROJECT_DETAILS", "PROJECT_NAME")
    PROJECT_ID = config.get("PROJECT_DETAILS", "PROJECT_ID")
    # path
    BASE_PATH = config.get("PATH", 'base_path')
    SUB_PATH = config.get("PATH", "sub_path")
    FULL_PATH = BASE_PATH + SUB_PATH
    ENABLE_CORS: bool = True
    CORS_URLS: list[str] = ["*.ilens.io"]
    CORS_ALLOW_CREDENTIALS: bool = True
    CORS_ALLOW_METHODS: list[str] = ["GET", "POST", "DELETE", "PUT"]
    CORS_ALLOW_HEADERS: list[str] = ["*"]
    LOG_LEVEL: Literal["INFO", "DEBUG", "ERROR", "QTRACE"] = "INFO"
    ENABLE_FILE_LOGGING: bool = False
    KEY_ENCRYPTION = "kliLensKLiLensKL"
    SECRET_KEY = "09d25e094faa6ca2556c818166b7a9563b93f7099f6f0f4caa6cf63b88e8d3e7"
    ALGORITHM = "HS256"
    ACCESS_TOKEN_EXPIRE_MINUTES = 30


class _Databases(BaseSettings):
    MONGO_URI: str
    DB_NAME: str


Services = _Services()
Databases = _Databases()

__all__ = [
    "PROJECT_NAME",
    "Services",
    "Databases",
]
