from scripts.core.handlers.normal_login import NormalLogin
from fastapi.responses import JSONResponse
from fastapi import status
from scripts.errors import ErrorMessages
from scripts.schemas.default_responses import DefaultFailureResponse, DefaultResponse
from scripts.utils.security.password_util import EncryptDecryptPassword


class LoginHandlers:
    def __init__(self):
        self.obj_login_handler = NormalLogin()
        self.pass_decrypt = EncryptDecryptPassword()
        self.login_type = ""

    def normal_login(self, user_data, request):
        self.login_type = "normal"
        # decrypting the password from the UI
        decrypted_password = self.pass_decrypt.password_decrypt(user_data.password)

        # validating the received inputs empty or not
        response = self.obj_login_handler.user_data_validation(
            user_data.email,
            decrypted_password)

        # Account is not registered
        if response is not None:
            return JSONResponse(content=DefaultFailureResponse(error=response).dict(),
                                status_code=status.HTTP_400_BAD_REQUEST)
        # checking for the account and password matching
        response, data = self.obj_login_handler.db_password_matching(self.login_type, user_data,
                                                                     decrypted_password)
        # if the passwords doesn't match with the db data
        if response is not None:
            return JSONResponse(content=DefaultFailureResponse(error=data).dict(),
                                status_code=status.HTTP_401_UNAUTHORIZED)

        #  generating the access tokens
        response = self.obj_login_handler.generate_cookie_tokens(user_data, request)
        # token generation unsuccessful
        if response is None:
            return JSONResponse(
                content=DefaultFailureResponse(message="Access Unsuccessful",
                                               error=ErrorMessages.ERROR_TOKEN_GENERATION).dict(),
                status_code=status.HTTP_403_FORBIDDEN)
        # sending successful response to UI
        return JSONResponse(
            content=DefaultResponse(message="Login Successful", data=response).dict(),
            status_code=status.HTTP_200_OK)

    # v1
    def google_login(self, request):
        pass

    # v2
    def microsoft_login(self, request):
        pass
