import datetime

from scripts.database.mongo.mongo_db import MongoUser
from scripts.errors import ErrorMessages
from scripts.logging.logger import logger
from scripts.utils.security.password_util import EncryptDecryptPassword
from scripts.utils.validations_util import UserDataValidations

obj_mongo_user = MongoUser()


class UserManagement:
    def __init__(self):
        self.method = "register"

    # for normal registration using email and password
    def normal_register(self, user_data):
        try:
            response, message = UserDataValidations.data_validation(user_data, 'normal', self.method)
            if not response:
                return message
            # fetching the data based on the username
            db_user_data = MongoUser().fetch_one_user_details(user_data.email)
            # if the user is not available
            if db_user_data:
                return {"message": ErrorMessages.ERROR_EMAIL_EXIST,
                        "data": {"username": user_data.email}}
            created_at = datetime.datetime.now()
            updated_at = datetime.datetime.now()
            reg_time = {"created_at": created_at, "updated_at": updated_at}
            user_data_dict = {key: (EncryptDecryptPassword().password_encrypt(value)
                                    if key == "password" else value) for key, value in user_data}
            user_data_reg = user_data_dict | reg_time
            if not obj_mongo_user.insert_new_user(user_data_reg):
                return {"message": ErrorMessages.ERROR_STORING_DATA,
                        "data": {"username": user_data_dict}}
            return {"message": "New user registered",
                    "data": {"username": user_data_dict["email"]}}
        except Exception as e:
            logger.exception(e)

    @staticmethod
    # for Google registration using gmail
    def google_register():
        try:
            return {"message": "Not available now"}
        except Exception as e:
            logger.exception(e)

    @staticmethod
    # for microsoft registration using microsoft account
    def microsoft_register():
        try:
            return {"message": "Not available"}
        except Exception as e:
            logger.exception(e)

    @staticmethod
    def fetch_user_details():
        cursor_data = MongoUser().fetch_all_user_details()
        list_user_data = []
        for users in cursor_data:
            list_user_data.append(users)
        return list_user_data
