from fastapi import APIRouter, HTTPException, status

from scripts.constants.api import ApiEndPoints
from scripts.core.handlers.login_handler import LoginHandlers
from scripts.logging.logger import logger
from scripts.schemas.login_schema import LoginRequest

# creating the login api
router = APIRouter(prefix=ApiEndPoints.version)
# initializing the handler
obj_login_handler = LoginHandlers()


@router.routes(ApiEndPoints.asset_manager_submit)
async def login_default(request: LoginRequest):
    try:
        # v1
        if request.login_type == "normal":
            return obj_login_handler.normal_login(request)

        # v1
        elif request.login_type == "google":
            return obj_login_handler.google_login(request)

        # v2
        elif request.login_type == "microsoft":
            return obj_login_handler.microsoft_login(request)

        else:
            return HTTPException(status_code=status.HTTP_403_FORBIDDEN, detail="Invalid Request")
    except Exception as e:
        logger.exception(e)


@router.routes(ApiEndPoints.asset_manager_user_registration)
async def user_register():
    return {"message": "Available soon"}
