from typing import Optional

from scripts.database.mongo.mongo_db import MongoUser
from scripts.logging.logger import logger
from scripts.schemas.project_schema import ResetPassword

obj_mongo_user = MongoUser()


class AuthorizeAccess:
    @staticmethod
    # authorize the user
    def admin_authorize(request):
        try:
            # returning the user details
            user_data = obj_mongo_user.fetch_one_user_details({"user_id": request.user_id})
            if user_data["user_role"] != "super_admin":
                return False
            return True
        except TypeError:
            return False
        except Exception as e:
            logger.error(f'Services Failed with error from authorize access {e}')
            return False

    @staticmethod
    def login_authorize(request, reset_data: Optional[ResetPassword] = None):
        try:
            if reset_data is not None:
                if reset_data.user_id != request.user_id:
                    return False
                return True
            if request.user_id:
                return True
            return False
        except Exception as e:
            logger.error(f'Services Failed with error from login authorize {e}')
            return False
