from __future__ import annotations

from validate_email import validate_email

from scripts.errors import ErrorMessages
from scripts.logging.logger import logger


# user data validations
class UserDataValidations:
    @staticmethod
    def register_data_validation(user_data, method, feature):
        try:
            if user_data.name == "":
                return False, ErrorMessages.ERROR_INVALID_NAME
            # checking for valid username
            if user_data.email == "" or validate_email(
                    user_data.email) is not True:
                return False, ErrorMessages.ERROR_INVALID_EMAIL
            # checking for valid password
            if method == 'general':
                if user_data.password == "" or user_data.password == "string":
                    return False, ErrorMessages.ERROR_INVALID_PASSWORD
                # Validate phone number
                if user_data.phone_number == "":
                    return False, ErrorMessages.ERROR_INVALID_PHONE_NUMBER
            if user_data.user_role == "" and method == 'general' and feature == 'register':
                return False, ErrorMessages.ERROR_INVALID_USER_ROLE
            return True, None
        except Exception as e:
            logger.error(f'Register data validation error {e}')
            return False, ErrorMessages.ERROR_IN_VALIDATION

    @staticmethod
    def update_data_validation(user_data):
        try:
            if user_data.name == "":
                return False, ErrorMessages.ERROR_INVALID_NAME
            if user_data.user_role == "":
                return False, ErrorMessages.ERROR_INVALID_USER_ROLE
            return True, None
        except Exception as e:
            logger.error(f'Update data validation error {e}')
            return False, ErrorMessages.ERROR_IN_VALIDATION
