import uvicorn
from fastapi import FastAPI

from scripts.config import applications_config
from scripts.logging.loggers import logger
from scripts.services.task_main_service import sender_app

app = FastAPI()
app.include_router(sender_app)

# starting the application
if __name__ == "__main__":
    try:
        print("Task 15")
        uvicorn.run(app, port=int(applications_config.uvicorn_port))
    except Exception as e:
        logger.error("Interruption occurred: ", e)
