from paho.mqtt.client import Client

from scripts.core.handlers.receiver_handlers.connection_mqtt_receiver import connect_mqtt
from scripts.core.handlers.receiver_handlers.message_mqtt_receive import message_mqtt
from scripts.logging.loggers import logger


def receive_mqtt(mqtt_host, port, request_no):
    try:
        # client object creation
        client = Client(userdata="Receiver")

        # connecting to broker
        client.connect(mqtt_host, int(port), int(request_no))
        client.on_connect = connect_mqtt

        # listening to the topic
        client.on_message = message_mqtt

        client.loop_forever()
    except Exception as e:
        logger.error("Exception occurred while calling the mqtt: ", e)
