from fastapi.routing import APIRouter

from scripts.config import applications_config
from scripts.constants import api_path_config
from scripts.core.handlers.receiver_handlers.receive_mqtt_data import receive_mqtt
from scripts.core.handlers.sender_handlers.mqtt_data_call import send_data_mqtt
from scripts.database.models.models_sites import Quality
from scripts.logging.loggers import logger

sender_app = APIRouter()
receiver_app = APIRouter()


@sender_app.post(api_path_config.route_sender_index + api_path_config.route_get)
def sender_get_data(pollution: Quality):
    try:
        status = send_data_mqtt(dict(pollution))
        return status
    except Exception as e:
        logger.error("Some exception in sender api: ", e)


@receiver_app.post(api_path_config.route_receiver_index + api_path_config.route_get)
def receiver_get_data():
    try:
        receive_mqtt(applications_config.mqtt_host, applications_config.mqtt_port, applications_config.request_no)
    except Exception as e:
        logger.error("Some exception in receiver api: ", e)
