from scripts.core.handlers.receiver_handlers.insert_data_redis import insert_data
from scripts.database import redis_db_connection
from scripts.logging.loggers import logger


def operations_call_(json_poll_data):
    try:
        # selecting the connection according to the quality
        mapper = {
            0: redis_db_connection.conn_good,
            1: redis_db_connection.conn_maintenance,
            2: redis_db_connection.conn_error
        }
        conn = mapper.get(json_poll_data['data_quality'])
        if conn:
            # insert the data to the db
            insert_data(conn, json_poll_data)
    except Exception as e:
        logger.exception("Redis mapper Failed", e)
