import json
import time

from scripts.config import applications_config
from scripts.database.models.models_sites import SitesEncoder
from scripts.logging.loggers import logger
from scripts.utils.mqtt_connections import sender_util_mqtt


def send_data_mqtt(dict_pollution_data):
    try:
        # dumps the list to json
        json_data = json.dumps(dict_pollution_data, cls=SitesEncoder)

        client = sender_util_mqtt()

        # publish the topic
        client.publish(applications_config.topic_name, json_data)

        # disconnecting from the mqtt
        client.disconnect()

        time.sleep(10)

        return {"message": "Data published to receiver", "status": "message sent", "data": json_data}
    except Exception as e:
        logger.error("Some exception occurred while sending file: ", e)
