import logging
import os
from logging.handlers import RotatingFileHandler

from scripts.config import applications_config


def get_logger():
    """
     Creates a rotating log
     """
    __logger__ = logging.getLogger('')

    # setting the logger level
    __logger__.setLevel(logging.INFO)

    # creating the format for the log
    log_formatter = f'%({applications_config.formatter_time})s - %({applications_config.formatter_level})-6s - %(message)s'
    time_format = "%Y-%m-%d %H:%M:%S"

    # getting the path for the logger
    file_path = applications_config.full_path

    # setting the format
    formatter = logging.Formatter(log_formatter, time_format)

    # creating the folder if not exist
    if not os.path.exists(file_path):
        os.makedirs(file_path)

    # joining the path
    log_file = os.path.join(f"{file_path}{applications_config.log_name}.log")

    # creating rotating file handler with max byte as 1
    temp_handler = RotatingFileHandler(log_file, maxBytes=1)

    # setting the formatter
    temp_handler.setFormatter(formatter)

    # setting the handler
    __logger__.addHandler(temp_handler)

    return __logger__


logger = get_logger()
