import json

from pydantic import BaseModel


class Sites(BaseModel):
    PM10: int
    PM2_5: int
    SO2: int
    NO2: int


class Quality(BaseModel):
    data: Sites
    site_id: str
    data_quality: int


class SitesEncoder(json.JSONEncoder):
    def default(self, obj):
        if isinstance(obj, Sites):
            return obj.dict()
        return super().default(obj)
