# Assignment 2




## Task 1: Working with Mongo - Advanced


## Areas covered:
- Timeseries Operation
- Working with NoSQL
- Working with Pandas

## Description:
You are given with a dataset of bicycle rental company in the form of a JSON file. The end goal of the project is to create an API interface that will provide the following: 

1.  Get the user who has the highest trip duration.
2. Get the user who has used the service the most.
3. Generate Excel Report based on `bike id`, `station name` and `start date`

Sample Document:
```json
{
  "tripduration": 889,
  "start station id": 268,
  "start station name": "Howard St & Centre St",
  "end station id": 3002,
  "end station name": "South End Ave & Liberty St",
  "bikeid": 22794,
  "usertype": "Subscriber",
  "birth year": 1961,
  "start station location": {
    "type": "Point",
    "coordinates": [
      -73.99973337,
      40.71910537
    ]
  },
  "end station location": {
    "type": "Point",
    "coordinates": [
      -74.015756,
      40.711512
    ]
  },
  "start time": {
    "$date": "2016-01-01T00:01:06.000Z"
  },
  "stop time": {
    "$date": "2016-01-01T00:15:56.000Z"
  }
}
```

Bonus Points: Use Mongo Aggregate framework

### Tools to use: 
1. Pycharm / VSCode
2. Robo3T / Studio3T / MongoDB Compass
3. PyMongo


### Reference:
https://www.mongodb.com/docs/manual/tutorial/query-documents/
https://www.mongodb.com/docs/manual/reference/operator/aggregation-pipeline/
https://pandas.pydata.org/docs/reference/api/pandas.DataFrame.to_excel.html
https://fastapi.tiangolo.com/advanced/custom-response/#fileresponse
https://pymongo.readthedocs.io/en/stable/


________________________________________________________
## Task 2: Working with Timeseries


## Areas covered:
- Timeseries Operation
- Working with Timeseries
- Working with Pandas

## Description:
You are given with a dataset of weather in the form of a CSV file. The end goal of the project is to create an API interface that will provide the following: 

1. Get daily, monthly, weekly and monthly aggregate (min, max, and average) of the data and generate report in Excel format.

Sample Document:


|Formatted Date               |Summary      |Precip Type|Temperature C|Apparent Temperature C|Humidity|Wind Speed (km/h)|Wind Bearing (degrees)|Visibility (km)|Loud Cover|Pressure (millibars)|
|-----------------------------|-------------|-----------|---------------|------------------------|--------|-----------------|----------------------|---------------|----------|--------------------|
|2006-04-01 00:00:00.000 +0200|Partly Cloudy|rain       |9.472222222    |7.388888889             |0.89    |14.1197          |251                   |15.8263        |0         |1015.13             |


### Tools to use: 
1. Pycharm / VSCode
2. Pandas 

### Reference:
https://kairosdb.github.io/docs/restapi/QueryMetrics.html
https://pypi.org/project/kairosdb-python/

## Task 3: Working with MQTT & REDIS

# Description

In a theatre, Tickets are to be given to people in queue, There are 2 counters for Gold  and Silver class.

Gold Class has 10 rows with 30 seats per row, Silver class has 5 rows with 25 seats per row
	
Store the information of booking, Maximum 5 tickets allowed in a booking.
	

- Publish message to a MQTT topic

- Subscribe message, Assign seats per requirement and store information to redis db.

sample format: 
```json
  {
	"mobile_no" : "9876543210",
	"preferred_class" :"Gold/Silver",
	"no_of_tickets" : 5
	}
```
	   
Use Redis for caching/storing information

create consumer's which consumes data from these topics and store to a redis db

### Tools to use: 
1. Pycharm / VSCode
2. MQTT - (paho-mqtt)
3. REDIS - (redis)

### Reference:
https://www.emqx.com/en/blog/how-to-use-mqtt-in-python

https://docs.redis.com/latest/rs/references/client_references/client_python/

