import logging
from utils.create_report_sample import DailyReportGenerator

# Configure logging
logging.basicConfig(level=logging.INFO, format='%(asctime)s - %(levelname)s - %(message)s')
logger = logging.getLogger(__name__)


def generate_daily_report():
    # Create an instance of DailyReportGenerator
    report_generator = DailyReportGenerator()

    # Generate the daily report
    report_path = report_generator.create_excel_report()

    # Send the email with the report
    report_generator.send_email_from_ut(filepath=report_path)

    return report_path


if __name__ == "__main__":
    try:
        report_path = generate_daily_report()
        logger.info(f"Generated Daily Report: {report_path}")
    except Exception as e:
        logger.error("Error generating daily report:", exc_info=True)
