import socket
import binascii

# Datalink Function Codes PRM=0
function_id = {
    0: "ACK",
    1: "NACK",
    11: "Link Status",
    15: "User Data"
}

# Data Link Function Codes PRM=1
alt_function_id = {
    0: "RESET Link",
    1: "Reset User Process",
    2: "TEST link",
    3: "User Data",
    4: "User Data",
    9: "Request Link Status"
}

def funct_lookup(id):
    if len(str(id))-2 < 5:
        funct_id = function_id.get(int(id, 2), "Unknown Function ID")
        id = int(id, 2)
    else:
        first_value = ord(id[1]) % 0x10
        second_value = int(id[4:8], 2)
        if first_value == 0:
            funct_id = function_id.get(second_value, "Unknown Function ID")
        else:
            funct_id = alt_function_id.get(second_value, "Unknown Function ID")
        id = second_value
    return f"{funct_id} ({id})"

def action(host, port):
    # Create a new socket
    sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    sock.settimeout(1)  # Set timeout to 1 second

    try:
        # Connect to the remote host
        sock.connect((str(host), port))

        # Query to pull the first 100 addresses
        first100 = binascii.unhexlify("056405C900000000364C056405C901000000DE8E056405C9020000009F84056405C9030000007746056405C9040000001D90056405C905000000F552056405C906000000B4580" +
                                   "56405C9070000005C9A056405C90800000019B9056405C909000000F17B056405C90A000000B071056405C90B000000058B3056405C90C0000003265056405C90D000000DAA705" +
                                   "56405C90E0000009BAD056405C90F000000736F056405C91000000011EB056405C911000000F929056405C912000000B823056405C91300000050E1056405C9140000003A37056" +
                                   "405C915000000D2F5056405C91600000093FF056405C9170000007B3D056405C9180000003E1E056405C919000000D6DC056405C91A00000097D6056405C91B0000007F140564" +
                                   "05C91C00000015C2056405C91D000000FD00056405C91E000000BC0A056405C91F00000054C8056405C920000000014F056405C921000000E98D056405C922000000A887056405" +
                                   "C9230000004045056405C9240000002A93056405C925000000C251056405C926000000835B056405C9270000006B99")


            # Send the query for the first 100 addresses
        sock.send(first100)

        # Receive the response for parsing
        response = sock.recv(1024)  # Adjust the buffer size as needed

        # If the response was timeout, return that we had a timeout
        if not response:
            sock.close()
            return False

        # Check if the response starts with 0x0564
        if response.startswith(b'\x05\x64'):
            # Close the socket
            sock.close()

            # Unpack the bit string for PRM checking as well as function codes
            ctrl = response[3]
            dstadd = int.from_bytes(response[5:6], byteorder='big')
            srceadd = int.from_bytes(response[6:7], byteorder='big')

            # Set up an output dictionary with values
            output = {
                "Source Address": srceadd,
                "Destination Address": dstadd,
                "Device Type": "DNP3",
                "Control": funct_lookup(bin(ctrl)),
            }

            # Return the output
            return output
        else:
            sock.close()
            return False

    except socket.error as e:
        return False

    finally:
        sock.close()

def get_info(ip,port):
  return(action(ip,port))

