import socket
import re
import binascii

def split_string(input_str, sep):
    return input_str.split(sep)

def action(host, port):
    # Create a socket
    sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    
    try:
        # Connect to the remote host
        sock.connect((str(host), int(port)))
        
        # Send the original query
        orig_query = binascii.unhexlify("666f7820612031202d3120666f782068656c6c6f0a7b0a" \
                     "666f782e76657273696f6e3d733a312e300a69643d693a310a" \
                     "686f73744e616d653d733a7870766d2d306f6d64633031786d790a" \
                     "686f7374416464726573733d733a3139322e3136382e312e3132350a" \
                     "6170702e6e616d653d733a576f726b62656e63680a6170702e766572" \
                     "73696f6e3d733a332e372e34340a766d2e6e616d653d733a4a61766120" \
                     "486f7453706f7428544d292053657276657220564d0a766d2e76657273" \
                     "696f6e3d733a32302e342d6230320a6f732e6e616d653d733a57696e64" \
                     "6f77732058500a6f732e76657273696f6e3d733a352e310a6c616e673d" \
                     "733a656e0a74696d655a6f6e653d733a416d65726963612f4c6f735f416e" \
                     "67656c65733b2d32383830303030303b333630303030303b30323a30303a" \
                     "30302e3030302c77616c6c2c6d617263682c382c6f6e206f722061667465" \
                     "722c73756e6461792c756e646566696e65643b30323a30303a30302e3030" \
                     "302c77616c6c2c6e6f76656d6265722c312c6f6e206f722061667465722c" \
                     "73756e6461792c756e646566696e65640a686f737449643d733a57696e2d" \
                     "393943422d443439442d353434322d303742420a766d557569643d733a3862" \
                     "3533306263382d373663352d343133392d613265612d306661626433393464" \
                     "3330350a6272616e6449643d733a76796b6f6e0a7d3b3b0a")
        sock.send(orig_query)
        # Receive response
        response = sock.recv(1024).decode('utf-8')
        # Split the response on newline character

        lines = split_string(response, "\n")
        
        to_return = {}
        
        # Parse the response and populate the to_return dictionary
        for line in lines:
            if "hostName" in line:
                temp = split_string(line, ":")
                to_return["Host Name"] = temp[1].strip()
            elif "hostAddress" in line:
                temp = split_string(line, ":")
                to_return["Host Address"] = temp[1].strip()
            elif "fox.version" in line:
                temp = split_string(line, ":")
                to_return["Fox Version"] = temp[1].strip()
            elif "app.name" in line:
                temp = split_string(line, ":")
                to_return["Application Name"] = temp[1].strip()
            elif "app.version" in line:
                temp = split_string(line, ":")
                to_return["Application Version"] = temp[1].strip()
            elif "vm.name" in line:
                temp = split_string(line, ":")
                to_return["VM Name"] = temp[1].strip()
            elif "vm.version" in line:
                temp = split_string(line, ":")
                to_return["VM Version"] = temp[1].strip()
            elif "os.name" in line:
                temp = split_string(line, ":")
                to_return["OS Name"] = temp[1].strip()
            elif "timeZone" in line:
                temp = split_string(line, ":")
                # Split again just for the timezone name
                temp2 = split_string(temp[1], ";")
            elif "hostId" in line:
                temp = split_string(line, ":")
                to_return["Host ID"] = temp[1].strip()
            elif "vmUuid" in line:
                temp = split_string(line, ":")
                to_return["VM UUID"] = temp[1].strip()
            elif "brandId" in line:
                temp = split_string(line, ":")
                to_return["Brand ID"] = temp[1].strip()
        return to_return
    except Exception as e:
        return False
    finally:
        sock.close()

def get_info(ip,port):
  return(action(ip,port))
