from protocol_enumerators import ethernetip_enum
from protocol_enumerators import s7_enum
from protocol_enumerators import bacnet
from protocol_enumerators import modbus
from protocol_enumerators import omron
import sqlite3
from datetime import datetime
import json_operations

probes=[s7_enum,ethernetip_enum,bacnet,modbus,omron]

def map_ports(ip,port):
	query=mydb.cursor()
	dev_type="Unknown"
	vendor="Unknown"
	firmware="Unknown"
	model="Unknown"
	for i in probes:
		res=i.get_info(ip,port)
		if(res):
			if(i.__name__=="protocol_enumerators.s7_enum"):
				dev_type=res['Module Type']+" "+res['System Name']
				vendor=res['Copyright']
				firmware=res['Module']+" "+res['Version']
				model=res['Serial Number']
				json_operations.update_asset(ip,"s7comm",datetime.now().strftime("%d-%m-%y %H:%M:%S"),dev_type,vendor,firmware,model)
				#updateproto='UPDATE inventory SET protocols=(select protocols from inventory where ip_address="'+ip+'")||":"||"s7comm",last_activity="'+datetime.now().strftime("%d-%m-%y %H:%M:%S")+'",type="'+dev_type+'",vendor="'+vendor+'",firmware_version="'+firmware+'",model="'+model+'" WHERE ip_address="'+ip+'"'
			elif(i.__name__=="protocol_enumerators.ethernetip_enum"):
				dev_type=res['Type']
				vendor=res['Vendor']
				firmware=res['ProductName']
				model=res['SerialNumber']
				json_operations.update_asset(ip, "enip", datetime.now().strftime("%d-%m-%y %H:%M:%S"), dev_type,vendor, firmware, model)
				#updateproto='UPDATE inventory SET protocols=(select protocols from inventory where ip_address="'+ip+'")||":"||"enip",last_activity="'+datetime.now().strftime("%d-%m-%y %H:%M:%S")+'",type="'+dev_type+'",vendor="'+vendor+'",firmware_version="'+firmware+'",model="'+model+'" WHERE ip_address="'+ip+'"'

			elif(i.__name__=="protocol_enumerators.bacnet"):
				dev_type=res['desc']
				vendor=res['vendorid']
				firmware=res['firmware']
				model=res['model']
				json_operations.update_asset(ip, "bacnet", datetime.now().strftime("%d-%m-%y %H:%M:%S"), dev_type, vendor,firmware, model)
				#updateproto='UPDATE inventory SET protocols=(select protocols from inventory where ip_address="'+ip+'")||":"||"bacnet",last_activity="'+datetime.now().strftime("%d-%m-%y %H:%M:%S")+'",type="'+dev_type+'",vendor="'+vendor+'",firmware_version="'+firmware+'",model="'+model+'" WHERE ip_address="'+ip+'"'

			elif(i.__name__=="protocol_enumerators.modbus"):
				dev_type=res['Device identification']
				vendor=res['Slave ID data']
				model=res['sid']
				json_operations.update_asset(ip, "modbus", datetime.now().strftime("%d-%m-%y %H:%M:%S"), dev_type, vendor,"Unknown", model)
				#updateproto='UPDATE inventory SET protocols=(select protocols from inventory where ip_address="'+ip+'")||":"||"modbus",last_activity="'+datetime.now().strftime("%d-%m-%y %H:%M:%S")+'",type="'+dev_type+'",vendor="'+vendor+'",firmware_version="'+firmware+'",model="'+model+'" WHERE ip_address="'+ip+'"'
			elif(i.__name__=="protocol_enumerators.omron"):
				dev_type='Omron Device'
				vendor='Omron Devices'
				firmware=res['Controller Version']
				model=res['Controller Model']
				json_operations.update_asset(ip, "omron", datetime.now().strftime("%d-%m-%y %H:%M:%S"), dev_type, vendor,firmware, model)
				#updateproto='UPDATE inventory SET protocols=(select protocols from inventory where ip_address="'+ip+'")||":"||"modbus",last_activity="'+datetime.now().strftime("%d-%m-%y %H:%M:%S")+'",type="'+dev_type+'",vendor="'+vendor+'",firmware_version="'+firmware+'",model="'+model+'" WHERE ip_address="'+ip+'"'
			break